import json, datetime, time


def fix_json(elem):
        # fix F1's not json compliant data
        elem = elem.replace("'", '"') \
            .replace('True', 'true') \
            .replace('False', 'false')
        return elem


class dataSender:
    def __init__(self, path, start_index=0):
        self.index = start_index
        self.time = -1
        with open(path, 'r') as f:
            self.data = json.load(f)

    def next(self):
        self.index += 1

        # try to keep realistic timing
        result_timestamp = self.try_timestamp()
        if result_timestamp[0]:
            #time.sleep(min(1, abs(self.time - result_timestamp[1])))
            self.time = result_timestamp[1]

        # give the data
        return json.dumps(self.data[self.index])

    def try_timestamp(self):
        try: 
            format_string = '%Y-%m-%dT%H:%M:%S.%f'
            time_string = self.data[self.index]['M'][0]['A'][-1]
            stamp = datetime.datetime.strptime(time_string[:-2], format_string).timestamp()

            return (True, stamp)
        
        except: 
            return (False, False)

        

if __name__ == "__main__":
    reader = dataSender("imola.json")
    [print(reader.next()) for i in range(100)]
